using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;

using Microsoft.DirectX;
using Microsoft.DirectX.DirectPlay;

using DarkStrideToolbox;
using DarkStride.StellarLanes.SharedDLL;


namespace DarkStride.StellarLanes.Server
{
	public class frmMain : System.Windows.Forms.Form
	{
		private DSSortedList m_oPlayerSocketIDToSessionGUIDLookup = new DSSortedList();
		#region Properties
		public Guid m_oAppGUID = new Guid(0x876a3032, 0xffd7, 0x46bd, 0x91, 0x8, 0xb4, 0x2f, 0x61, 0x7b, 0x9b, 0xeA);
		private DSNetworkWrapper m_oDSNetworkWrapper = null;
		private DSSortedList m_oSessions = new DSSortedList();
		private const int m_cDEFAULTPORT = 5461;
		private string m_sServerName = "";
		private Thread m_oMainLoop = null;
		#endregion

		#region System Stuff
		private System.Windows.Forms.ImageList imgIcons;
		private System.Windows.Forms.GroupBox grpSession;
		private System.Windows.Forms.ListView lvwSessions;
		private System.Windows.Forms.ColumnHeader clmnhName;
		private System.Windows.Forms.ColumnHeader clmnhUserCount;
		private System.Windows.Forms.Button cmdStopSession;
		private System.Windows.Forms.Button cmdStartSession;
		private System.Windows.Forms.ListBox lstLog;
		private System.Windows.Forms.Label lblLog;
		private System.Windows.Forms.Button cmdSendLobbyMsg;
		private System.Windows.Forms.TextBox txtSendMsg;
		private System.ComponentModel.IContainer components;

		public frmMain()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(frmMain));
			this.imgIcons = new System.Windows.Forms.ImageList(this.components);
			this.grpSession = new System.Windows.Forms.GroupBox();
			this.lblLog = new System.Windows.Forms.Label();
			this.lstLog = new System.Windows.Forms.ListBox();
			this.cmdStopSession = new System.Windows.Forms.Button();
			this.cmdStartSession = new System.Windows.Forms.Button();
			this.lvwSessions = new System.Windows.Forms.ListView();
			this.clmnhName = new System.Windows.Forms.ColumnHeader();
			this.clmnhUserCount = new System.Windows.Forms.ColumnHeader();
			this.cmdSendLobbyMsg = new System.Windows.Forms.Button();
			this.txtSendMsg = new System.Windows.Forms.TextBox();
			this.grpSession.SuspendLayout();
			this.SuspendLayout();
			// 
			// imgIcons
			// 
			this.imgIcons.ImageSize = new System.Drawing.Size(16, 16);
			this.imgIcons.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imgIcons.ImageStream")));
			this.imgIcons.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// grpSession
			// 
			this.grpSession.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSession.Controls.Add(this.cmdSendLobbyMsg);
			this.grpSession.Controls.Add(this.txtSendMsg);
			this.grpSession.Controls.Add(this.lblLog);
			this.grpSession.Controls.Add(this.lstLog);
			this.grpSession.Controls.Add(this.cmdStopSession);
			this.grpSession.Controls.Add(this.cmdStartSession);
			this.grpSession.Controls.Add(this.lvwSessions);
			this.grpSession.Location = new System.Drawing.Point(8, 8);
			this.grpSession.Name = "grpSession";
			this.grpSession.Size = new System.Drawing.Size(528, 352);
			this.grpSession.TabIndex = 14;
			this.grpSession.TabStop = false;
			this.grpSession.Text = "Sessions";
			// 
			// lblLog
			// 
			this.lblLog.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblLog.Location = new System.Drawing.Point(16, 248);
			this.lblLog.Name = "lblLog";
			this.lblLog.Size = new System.Drawing.Size(128, 16);
			this.lblLog.TabIndex = 18;
			this.lblLog.Text = "Log:";
			// 
			// lstLog
			// 
			this.lstLog.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lstLog.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lstLog.Location = new System.Drawing.Point(16, 264);
			this.lstLog.Name = "lstLog";
			this.lstLog.Size = new System.Drawing.Size(504, 54);
			this.lstLog.TabIndex = 17;
			// 
			// cmdStopSession
			// 
			this.cmdStopSession.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdStopSession.Enabled = false;
			this.cmdStopSession.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.cmdStopSession.ImageAlign = System.Drawing.ContentAlignment.BottomLeft;
			this.cmdStopSession.ImageIndex = 0;
			this.cmdStopSession.ImageList = this.imgIcons;
			this.cmdStopSession.Location = new System.Drawing.Point(408, 56);
			this.cmdStopSession.Name = "cmdStopSession";
			this.cmdStopSession.Size = new System.Drawing.Size(104, 24);
			this.cmdStopSession.TabIndex = 16;
			this.cmdStopSession.Text = "      Stop Session";
			this.cmdStopSession.Click += new System.EventHandler(this.cmdStopSession_Click);
			// 
			// cmdStartSession
			// 
			this.cmdStartSession.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdStartSession.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.cmdStartSession.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.cmdStartSession.ImageIndex = 1;
			this.cmdStartSession.ImageList = this.imgIcons;
			this.cmdStartSession.Location = new System.Drawing.Point(408, 24);
			this.cmdStartSession.Name = "cmdStartSession";
			this.cmdStartSession.Size = new System.Drawing.Size(104, 24);
			this.cmdStartSession.TabIndex = 15;
			this.cmdStartSession.Text = "      Start Session";
			this.cmdStartSession.Click += new System.EventHandler(this.cmdStartSession_Click);
			// 
			// lvwSessions
			// 
			this.lvwSessions.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvwSessions.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lvwSessions.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						  this.clmnhName,
																						  this.clmnhUserCount});
			this.lvwSessions.FullRowSelect = true;
			this.lvwSessions.Location = new System.Drawing.Point(16, 24);
			this.lvwSessions.Name = "lvwSessions";
			this.lvwSessions.Size = new System.Drawing.Size(384, 224);
			this.lvwSessions.TabIndex = 14;
			this.lvwSessions.View = System.Windows.Forms.View.Details;
			this.lvwSessions.SelectedIndexChanged += new System.EventHandler(this.lvwSessions_SelectedIndexChanged);
			// 
			// clmnhName
			// 
			this.clmnhName.Text = "Name";
			this.clmnhName.Width = 260;
			// 
			// clmnhUserCount
			// 
			this.clmnhUserCount.Text = "# Users";
			// 
			// cmdSendLobbyMsg
			// 
			this.cmdSendLobbyMsg.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.cmdSendLobbyMsg.Location = new System.Drawing.Point(472, 320);
			this.cmdSendLobbyMsg.Name = "cmdSendLobbyMsg";
			this.cmdSendLobbyMsg.Size = new System.Drawing.Size(48, 20);
			this.cmdSendLobbyMsg.TabIndex = 35;
			this.cmdSendLobbyMsg.Text = "Send";
			this.cmdSendLobbyMsg.Click += new System.EventHandler(this.cmdSendLobbyMsg_Click);
			// 
			// txtSendMsg
			// 
			this.txtSendMsg.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.txtSendMsg.Location = new System.Drawing.Point(16, 320);
			this.txtSendMsg.Name = "txtSendMsg";
			this.txtSendMsg.Size = new System.Drawing.Size(453, 20);
			this.txtSendMsg.TabIndex = 34;
			this.txtSendMsg.Text = "";
			// 
			// frmMain
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(544, 365);
			this.Controls.Add(this.grpSession);
			this.Name = "frmMain";
			this.Text = "App Server";
			this.Load += new System.EventHandler(this.frmMain_Load);
			this.grpSession.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new frmMain());
		}

		#endregion


		private void frmMain_Load(object sender, System.EventArgs e)
		{
			ServiceProviderInformation oServiceProv;
			frmStartServer oStartDlg = new frmStartServer();
			frmPleaseWait oPleaseWait = null;


			//Start our network
			m_oDSNetworkWrapper = new DSNetworkWrapper();

			//Now go through and show all the services available
			if( m_oDSNetworkWrapper.Initialize( m_oAppGUID,false ) == false )
			{
				throw new System.Exception( "Failed to initialize DirectX.DirectPlay network." );
			}
			m_oDSNetworkWrapper.RegisterDelegate_DataReceived( new DSNetworkWrapper.CallbackDataReceived( this.DataReceived ) );
			m_oDSNetworkWrapper.RegisterDelegate_PlayerJoined( new DSNetworkWrapper.CallbackPlayerJoined( this.PlayerJoined ) );
			m_oDSNetworkWrapper.RegisterDelegate_PlayerQuit( new DSNetworkWrapper.CallbackPlayerQuit( this.PlayerQuit ) );

			//Now start a service
			oStartDlg.ServerName = "New World Order (1)";
			oStartDlg.Port = m_cDEFAULTPORT;
			oStartDlg.DSNetworkWrapper = m_oDSNetworkWrapper;
			if( oStartDlg.ShowDialog() == System.Windows.Forms.DialogResult.Yes )
			{
				oPleaseWait = new frmPleaseWait();
				oPleaseWait.Show();
				oPleaseWait.Refresh();

				m_sServerName = oStartDlg.Name;
				oServiceProv = m_oDSNetworkWrapper.FindServiceProvider( oStartDlg.ServiceProviderGUID );
				m_oDSNetworkWrapper.HostGame( oServiceProv,m_oAppGUID,m_sServerName,"App Server",oStartDlg.Port );

				//Start the main app
				m_oMainLoop = new Thread( new ThreadStart( this.MainSessionLoop ) );
				m_oMainLoop.IsBackground = true;
				m_oMainLoop.Start();

				oPleaseWait.Close();
			}
			else
			{
				this.Close();
			}
		}


		private void cmdStartSession_Click(object sender, System.EventArgs e)
		{
			Hazard oHazard = null;
			Session oNewSession = null;
			frmStartSession oStartDlg = new frmStartSession();


			//Now start a Session
			oStartDlg.SessionName = "Test Lab 1";
			if( oStartDlg.ShowDialog() == System.Windows.Forms.DialogResult.Yes )
			{
				oNewSession = new Session();
				oNewSession.SessionName = oStartDlg.SessionName;

				//Add 5 random entities
				for( int i=0 ; i<5 ; i++ )
				{
					oHazard = new Hazard();
					oHazard.Pos = new Vector2( (float)DSMisc.GetRnd() * 100,(float)DSMisc.GetRnd() * 100 );
					oHazard.Vel = new Vector2( (float)DSMisc.GetRnd() * 2 - 1,(float)DSMisc.GetRnd() * 2 - 1 );
					oNewSession.AddEntity( oHazard );
				}

				lock( m_oSessions )
				{
					m_oSessions.Add( oNewSession.GUID,oNewSession );
				}

				UpdateSessionList();
				SendSessionToAllPlayerList( oNewSession );
			}	
		}

		private void cmdStopSession_Click(object sender, System.EventArgs e)
		{
			Session oSession = null;
			string sGUID = "";


			sGUID = (string)lvwSessions.SelectedItems[0].Tag;

			lock( m_oSessions )
			{
				oSession = (Session)m_oSessions.GetByKey( sGUID );
				m_oSessions.Remove( sGUID );
			}

			UpdateSessionList();
			RemoveSessionFromAllPlayerList( oSession );
		}

		private void cmdSendLobbyMsg_Click(object sender, System.EventArgs e)
		{
			SendChatMsgToAllUnBusyPlayers( m_oDSNetworkWrapper.Me,txtSendMsg.Text );
			txtSendMsg.Text = "";		
		}


		private void MainSessionLoop()
		{
			DSSortedList oTempSessions = null;
			Session oLoopSession = null;


			while( true )
			{
				//Advance all our sessions
				lock( m_oSessions )
				{
					oTempSessions = m_oSessions.Clone();
				}

				for( int nSessionIndex=0 ; nSessionIndex<oTempSessions.Count ; nSessionIndex++ )
				{
					oLoopSession = (Session)oTempSessions.GetByIndex( nSessionIndex );
					oLoopSession.Advance( .5 );
				}


				Thread.Sleep( 500 );
			}
		}

		private void LogEvent( string sEvent )
		{
			string sTime = DateTime.Now.ToString( "yyyy-MM-dd hh:mm:ss" ) + ": ";
			lstLog.Items.Add( sTime + sEvent );
			lstLog.SelectedIndex = lstLog.Items.Count-1;
		}


		private void UpdateSessionList()
		{
			DSSortedList oTempSessions = null;
			Session oLoopSession = null;
			ListViewItem oItem = null;


			lvwSessions.Items.Clear();

			lock( m_oSessions )
			{
				oTempSessions = m_oSessions.Clone();
			}

			for( int nSessionIndex=0 ; nSessionIndex<oTempSessions.Count ; nSessionIndex++ )
			{
				oLoopSession = (Session)oTempSessions.GetByIndex( nSessionIndex );
				oItem = lvwSessions.Items.Add( oLoopSession.SessionName );
				oItem.SubItems.Add( "0" );
				oItem.Tag = oLoopSession.GUID;
			}

			UpdateEnabledStatus();
		}

		private void lvwSessions_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			UpdateEnabledStatus();
		}
		private void UpdateEnabledStatus()
		{
			cmdStopSession.Enabled = ( lvwSessions.SelectedIndices.Count > 0 );
		}


		#region Remoting Functions
		private void DataReceived( DSNetworkPlayer oSendingPlayer,DSNetworkPacket oPacket )
		{
			if( oPacket.MsgType == (int)enumNetMsg.LobbyChat )
			{
				int nSenderSocketID = 0;
				string sMessage = "";
				DSNetworkPlayer oSenderPlayer = null;


				NetMsg.Rcv_LobbyChat( oPacket,ref nSenderSocketID,ref sMessage );
				oSenderPlayer = m_oDSNetworkWrapper.GetPlayer( nSenderSocketID );

				//Forward the message to anyone not in a session
				SendChatMsgToAllUnBusyPlayers( oSenderPlayer,sMessage );
			}
			else if( oPacket.MsgType == (int)enumNetMsg.RequestingSessionList )
			{
				SendPlayerSessionList( oSendingPlayer );
			}
			else if( oPacket.MsgType == (int)enumNetMsg.JoinSession )
			{
				string sSessionGUID = "";

				NetMsg.Rcv_JoinSession( oPacket,ref sSessionGUID );
				m_oPlayerSocketIDToSessionGUIDLookup.Add( oSendingPlayer.SocketID,sSessionGUID );
			}
			else if( oPacket.MsgType == (int)enumNetMsg.QuitSession )
			{
				string sSessionGUID = "";

				NetMsg.Rcv_QuitSession( oPacket,ref sSessionGUID );
				m_oPlayerSocketIDToSessionGUIDLookup.Remove( oSendingPlayer.SocketID );
			}
		}
		private void PlayerJoined( DSNetworkPlayer oNewPlayer,bool bUs )
		{
			if( bUs == true )
			{
				LogEvent( "Server started." );
			}
			else
			{
				LogEvent( oNewPlayer.Name + " joined." );
			}

			m_oPlayerSocketIDToSessionGUIDLookup.Remove( oNewPlayer.SocketID );
		}
		private void PlayerQuit( DSNetworkPlayer oLeavingPlayer )
		{
			LogEvent( oLeavingPlayer.Name + " quit." );

			m_oPlayerSocketIDToSessionGUIDLookup.Remove( oLeavingPlayer.SocketID );
		}


		private void SendSessionToAllPlayerList( Session oSession )
		{
			DSNetworkPlayer oLoopPlayer = null;


			//Forward the message to anyone not in a session
			for( int i=0 ; i<m_oDSNetworkWrapper.Players.Count ; i++ )
			{
				if( i>m_oDSNetworkWrapper.Players.Count ){ break; }
				oLoopPlayer = (DSNetworkPlayer)m_oDSNetworkWrapper.Players.GetByIndex( i );
					
				if( oLoopPlayer.IsMe == false &&
					m_oPlayerSocketIDToSessionGUIDLookup.ContainsKey( oLoopPlayer.SocketID ) == false )
				{
					NetMsg.Send_AddSession( m_oDSNetworkWrapper,oLoopPlayer,oSession );
				}
			}	
		}
		private void RemoveSessionFromAllPlayerList( Session oSession )
		{
			DSNetworkPlayer oLoopPlayer = null;


			//Forward the message to anyone not in a session
			for( int i=0 ; i<m_oDSNetworkWrapper.Players.Count ; i++ )
			{
				if( i>m_oDSNetworkWrapper.Players.Count ){ break; }
				oLoopPlayer = (DSNetworkPlayer)m_oDSNetworkWrapper.Players.GetByIndex( i );
					
				if( oLoopPlayer.IsMe == false &&
					m_oPlayerSocketIDToSessionGUIDLookup.ContainsKey( oLoopPlayer.SocketID ) == false )
				{
					NetMsg.Send_DelSession( m_oDSNetworkWrapper,oLoopPlayer,oSession );
				}
			}	
		}
		private void SendPlayerSessionList( DSNetworkPlayer oPlayer )
		{
			DSSortedList oTempSessions = null;
			Session oLoopSession = null;


			lock( m_oSessions )
			{
				oTempSessions = m_oSessions.Clone();
			}
			for( int i=0 ; i<oTempSessions.Count ; i++ )
			{
				oLoopSession = (Session)oTempSessions.GetByIndex( i );
				NetMsg.Send_AddSession( m_oDSNetworkWrapper,oPlayer,oLoopSession );
			}
		}
		private void SendChatMsgToAllUnBusyPlayers( DSNetworkPlayer oSenderPlayer,string sMessage )
		{
			DSNetworkPlayer oLoopPlayer = null;


			//Show it for us too
			if( oSenderPlayer != null )
			{
				lstLog.Items.Add( oSenderPlayer.Name + ": " + sMessage );
			}
			else
			{
				lstLog.Items.Add( "Unknown: " + sMessage );
			}
			lstLog.SelectedIndex = lstLog.Items.Count - 1;


			//Forward the message to anyone not in a session
			for( int i=0 ; i<m_oDSNetworkWrapper.Players.Count ; i++ )
			{
				if( i>m_oDSNetworkWrapper.Players.Count ){ break; }
				oLoopPlayer = (DSNetworkPlayer)m_oDSNetworkWrapper.Players.GetByIndex( i );
					
				if( oLoopPlayer.IsMe == false && 
					oSenderPlayer.SocketID != oLoopPlayer.SocketID &&
					m_oPlayerSocketIDToSessionGUIDLookup.ContainsKey( oLoopPlayer.SocketID ) == false )
				{
					NetMsg.Send_LobbyChat( m_oDSNetworkWrapper,oSenderPlayer,oLoopPlayer,sMessage );
				}
			}	
		}
		#endregion
	}
}
